<?php
/*--------------------------------------------------------------------
 AttributeWeightDto.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitWeight\Database\Repository\DTO;

/**
 * Class AttributeWeightDto
 * @package Gambio\Shop\Attributes\SellingUnitWeight\Database\Repository\DTO
 */
class AttributeWeightDto
{
    /**
     * @var float
     */
    protected $weight;
    
    /**
     * @var string
     */
    protected $weightPrefix;
    
    
    /**
     * AttributeWeightDto constructor.
     *
     * @param float  $weight
     * @param string $weightPrefix
     */
    public function __construct(float $weight, string $weightPrefix)
    {
        $this->weight       = $weight;
        $this->weightPrefix = $weightPrefix;
    }
    
    
    /**
     * @return float
     */
    public function weight(): float
    {
        return $this->weight;
    }
    
    
    /**
     * @return string
     */
    public function weightPrefix(): string
    {
        return $this->weightPrefix;
    }
}